#ifndef __HW2_H_INCLUDE__
#define __HW2_H_INCLUDE__

#include <iostream>
#include <string>

using std::istream;
using std::ostream;
using std::string;

class TSet {
	public:
		TSet();
		TSet( const char* n );
		~TSet();

		void initial();
		TSet& operator=( const TSet& T );
		string in( const char& c );

		friend TSet operator+( const TSet& A, const TSet& B );
		friend TSet operator*( const TSet& A, const TSet& B );
		friend TSet operator-( const TSet& A, const TSet& B );
		friend string operator>=( const TSet& A, const TSet& B );
		friend istream& operator>>( istream& i, TSet& T );
		friend ostream& operator<<( ostream& o, const TSet& T );

	private:
		const static int MAXSIZE = 256;
		bool elem[MAXSIZE];
		string name;
};

#endif
