#include <iostream>
#include <string>
#include "hw2.h"

using std::cin;
using std::cout;
using std::endl;
using std::string;

TSet::TSet() {
    initial();
}

TSet::TSet( const char* n )
    :   name(n) {
    initial();
}

TSet::~TSet() {
}

TSet& TSet::operator=( const TSet& T ) {
	name = T.name;
    for( int i=0 ; i<T.MAXSIZE ; i++ )
        elem[i] = T.elem[i];
}

/* help function */
void TSet::initial() {
    for( int i=0 ; i<MAXSIZE ; i++ )
		elem[i] = false;
}

string TSet::in( const char& c ) {
    string s = "";
	s += "'";
	s.append( 1, c );
	s += "' is ";
	if( elem[ static_cast<int>( c ) ]!= true )
		s += "not in";
	else
        s += "in";
	s += " " + name;
	return s;
}

TSet operator+( const TSet& A, const TSet& B ) {
	TSet T;
	T.name = A.name + "+" + B.name;
	for( int i=0 ; i<T.MAXSIZE ; i++ )
		T.elem[i] = ( A.elem[i] | B.elem[i] );
	return T;
}

TSet operator*( const TSet& A, const TSet& B ) {
	TSet T;
	T.name = A.name + "*" + B.name;
	for( int i=0 ; i<T.MAXSIZE ; i++ )
		T.elem[i] = ( A.elem[i] & B.elem[i] );
	return T;
}

TSet operator-( const TSet& A, const TSet& B ) {
	TSet T;
	T.name = A.name + "-" + B.name;
	for( int i=0 ; i<T.MAXSIZE ; i++ )
		T.elem[i] = ( A.elem[i] ^ ( A.elem[i] & B.elem[i] ) );
	return T;
}

string operator>=( const TSet& A, const TSet& B ) {
	int i;
	string s = A.name + " ";
	for( i=0 ; i<A.MAXSIZE ; i++ ) {
		if( ( A.elem[i] & B.elem[i] ) != B.elem[i] ) {
			s += "does not contain";
			break;
		}
	}
	if( i==A.MAXSIZE )
        s += "contains";
    s += " " + B.name;
	return s;
}

istream& operator>>( istream& i, TSet& T ) {
	string iStr;

	getline( cin, iStr );

	for( unsigned int e=0 ; e<iStr.length() ; e++ )
		T.elem[ static_cast<int>(iStr[e]) ] = true;

    return i;
}

ostream& operator<<( ostream& o, const TSet& T ) {
    o << T.name << ": " << "{";
	for( int i=0 ; i<T.MAXSIZE ; i++ )
		if( T.elem[i] == true ) o << static_cast<char>(i);
	o << "}";
	return o;
}
