/*
 * Copyright (c) 1997-1998 Borland International, Inc. All Rights Reserved.
 * 
 * This SOURCE CODE FILE, which has been provided by Borland as part
 * of a Borland product for use ONLY by licensed users of the product,
 * includes CONFIDENTIAL and PROPRIETARY information of Borland.  
 *
 * USE OF THIS SOFTWARE IS GOVERNED BY THE TERMS AND CONDITIONS 
 * OF THE LICENSE STATEMENT AND LIMITED WARRANTY FURNISHED WITH
 * THE PRODUCT.
 *
 * IN PARTICULAR, YOU WILL INDEMNIFY AND HOLD BORLAND, ITS RELATED
 * COMPANIES AND ITS SUPPLIERS, HARMLESS FROM AND AGAINST ANY CLAIMS
 * OR LIABILITIES ARISING OUT OF THE USE, REPRODUCTION, OR DISTRIBUTION
 * OF YOUR PROGRAMS, INCLUDING ANY CLAIMS OR LIABILITIES ARISING OUT OF
 * OR RESULTING FROM THE USE, MODIFICATION, OR DISTRIBUTION OF PROGRAMS
 * OR FILES CREATED FROM, BASED ON, AND/OR DERIVED FROM THIS SOURCE
 * CODE FILE.
 */
package borland.samples.tutorial.textedit;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import borland.jbcl.control.*;
import borland.jbcl.layout.*;

public class TextEditFrame extends DecoratedFrame {
  BorderLayout borderLayout1 = new BorderLayout();
  BevelPanel bevelPanel1 = new BevelPanel();
  MenuBar menuBar1 = new MenuBar();
  Menu menuFile = new Menu();
  MenuItem menuFileExit = new MenuItem();
  Menu menuHelp = new Menu();
  MenuItem menuHelpAbout = new MenuItem();
  ButtonBar buttonBar = new ButtonBar();
  StatusBar statusBar = new StatusBar();
  BorderLayout borderLayout2 = new BorderLayout();
  TextArea textArea1 = new TextArea();
  MenuItem menuItem1 = new MenuItem();
  MenuItem menuItem2 = new MenuItem();
  MenuItem menuItem3 = new MenuItem();
  MenuItem menuItem4 = new MenuItem();
  Menu menu1 = new Menu();
  MenuItem menuItem5 = new MenuItem();
  MenuItem menuItem6 = new MenuItem();
  MenuItem menuItem7 = new MenuItem();
  FontChooser fontChooser1 = new FontChooser();
  ColorChooser colorChooser1 = new ColorChooser();
  Filer filer1 = new Filer();
  String currFileName = null;  // path plus filename. null means new / untitled
  boolean dirty = false;  // true means modified text
  Message message1 = new Message();

  //Construct the frame
  public TextEditFrame() {
    try {
      jbInit();
      updateCaption();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  //Component initialization
  public void jbInit() throws Exception{
    this.setLayout(borderLayout1);
    this.setSize(new Dimension(400, 300));
    this.setTitle("TextEdit");
    menuFile.setLabel("File");
    menuFileExit.setLabel("Exit");
    menuFileExit.addActionListener(new TextEditFrame_menuFileExit_ActionAdapter(this));
    menuHelp.setLabel("Help");
    menuHelpAbout.setLabel("About");
    menuHelpAbout.addActionListener(new TextEditFrame_menuHelpAbout_ActionAdapter(this));
    buttonBar.setButtonType(ButtonBar.IMAGE_ONLY);
    buttonBar.setLabels(new String[] {"Open", "Save", "About"});
    textArea1.addTextListener(new TextEditFrame_textArea1_textAdapter(this));
    buttonBar.addActionListener(new TextEditFrame_buttonBar_actionAdapter(this));
    menuItem1.setLabel("New");
    menuItem1.addActionListener(new TextEditFrame_menuItem1_actionAdapter(this));
    menuItem2.setLabel("Open");
    menuItem2.addActionListener(new TextEditFrame_menuItem2_actionAdapter(this));
    menuItem3.setLabel("Save");
    menuItem3.addActionListener(new TextEditFrame_menuItem3_actionAdapter(this));
    menuItem4.setLabel("Save As");
    menuItem4.addActionListener(new TextEditFrame_menuItem4_actionAdapter(this));
    menu1.setLabel("Edit");
    menuItem5.setLabel("Font");
    menuItem5.addActionListener(new TextEditFrame_menuItem5_actionAdapter(this));
    menuItem6.setLabel("Foreground Color");
    menuItem6.addActionListener(new TextEditFrame_menuItem6_actionAdapter(this));
    menuItem7.setLabel("Background Color");
    menuItem7.addActionListener(new TextEditFrame_menuItem7_actionAdapter(this));
    fontChooser1.setFrame(this);
    fontChooser1.setTitle("Font");
    colorChooser1.setFrame(this);
    filer1.setFrame(this);
    message1.setFrame(this);
    buttonBar.setImageBase("image");
    buttonBar.setImageNames(new String[] {"openFile.gif", "closeFile.gif", "help.gif"});
    bevelPanel1.setLayout(borderLayout2);
    menuFile.add(menuItem1);
    menuFile.add(menuItem2);
    menuFile.add(menuItem3);
    menuFile.add(menuItem4);
    menuFile.addSeparator();
    menuFile.add(menuFileExit);
    menuHelp.add(menuHelpAbout);
    menuBar1.add(menuFile);
    menuBar1.add(menu1);
    menuBar1.add(menuHelp);
    this.setMenuBar(menuBar1);
    this.add(buttonBar, BorderLayout.NORTH);
    this.add(statusBar, BorderLayout.SOUTH);
    this.add(bevelPanel1, BorderLayout.CENTER);
    bevelPanel1.add(textArea1, BorderLayout.CENTER);
    menu1.add(menuItem5);
    menu1.add(menuItem6);
    menu1.add(menuItem7);
  }

  /**
   * Display the About box.
   */
  void helpAbout() {
    TextEditFrame_AboutBox dlg = new TextEditFrame_AboutBox(this);
    Dimension dlgSize = dlg.getPreferredSize();
    Dimension frmSize = getSize();
    Point loc = getLocation();
    dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
    dlg.setModal(true);
    dlg.show();
  }

  /**
   * Handle the File|Open menu or button, invoking okToAbandon and openFile
   * as needed.
   */
  void fileOpen() {
    if (!okToAbandon()) {
      return;
    }

    // Filer makes use of a java.awt.FileDialog, and so its
    // mode property uses the same values as those of FileDialog.
    filer1.setMode(FileDialog.LOAD); // Use the OPEN version of the dialog.

    // Make the dialog visible as a modal (default) dialog box.
    filer1.show();

    // Upon return, getFile() will be null if user cancelled the dialog.
    if (filer1.getFile() != null) {
      // Non-null file property after return implies user
      // selected a file to open.

      // Call openFile to attempt to load the text from file into TextArea
      openFile(filer1.getDirectory()+filer1.getFile());
    }
  }

  /**
   * Open named file; read text from file into textArea1; report to statusBar.
   * @param fileName the name of the text file on disk
   */
  void openFile(String fileName)
  {
    try
    {
      // Open a file of the given name.
      File file = new File(fileName);

      // Get the size of the opened file.
      int size = (int)file.length();

      // Set to zero a counter for counting the number of
      // characters that have been read from the file.
      int chars_read = 0;

      // Create an input reader based on the file, so we can read its data.
      // FileReader handles international character encoding conversions.
      FileReader in = new FileReader(file);

      // Create a character array of the size of the file,
      // to use as a data buffer, into which we will read
      // the text data.
      char[] data = new char[size];

      // Read all available characters into the buffer.
      while(in.ready()) {
        // Increment the count for each character read,
        // and accumulate them in the data buffer.
        chars_read += in.read(data, chars_read, size - chars_read);
      }
      in.close();

      // Create a temporary string containing the data,
      // and set the string into the TextArea.
      textArea1.setText(new String(data, 0, chars_read));

      // Cache the currently opened filename for use at save time...
      this.currFileName = fileName;
      // ...and mark the edit session as being clean
      this.dirty = false;

      // Display the name of the opened directory+file in the statusBar.
      statusBar.setText("Opened "+fileName);

      updateCaption();
    }
    catch (IOException e)
    {
      statusBar.setText("Error opening "+fileName);
    }
  }

  /**
   * Save current file; handle not yet having a filename; report to statusBar.
   * @return false if save did not occur.
   */
  boolean saveFile()
  {

    // Handle the case where we don't have a file name yet.
    if (currFileName == null) {
      return saveAsFile();
    }

    try
    {
      // Open a file of the current name.
      File file = new File (currFileName);

      // Create an output writer that will write to that file.
      // FileWriter handles international characters encoding conversions.
      FileWriter out = new FileWriter(file);
      String text = textArea1.getText();
      out.write(text);
      out.close();
      this.dirty = false;
      updateCaption();
      return true;
    }
    catch (IOException e) {
      statusBar.setText("Error saving "+currFileName);
    }
    return false;
  }

  /**
   * Save current file, asking user for new destination name.
   * Report to statuBar.
   * @return false means user cancelled the SaveAs
   */
  boolean saveAsFile() {
    // Filer makes use of a java.awt.FileDialog, so its
    // mode property uses the same values as those of FileDialog.
    filer1.setMode(FileDialog.SAVE); // Use the SAVE version of the dialog.

    // Make the dialog visible as a modal (default) dialog box.
    filer1.show();

    // Upon return, getFile() will be null if user cancelled the dialog.
    if (filer1.getFile() != null) {
      // Non-null file property after return implies user
      // selected a filename to save to.

      // Set the current file name to the user's selection,
      // then do a regular saveFile
      currFileName = filer1.getDirectory()+filer1.getFile();
      return saveFile();
    }
    else {
      return false;
    }
  }

  /**
   * Check if file is dirty.
   * If so get user to make a "Save? yes/no/cancel" decision.
   * @return true if user saved here (Yes), or didn't care (No)
   * @return false if user hits cancel.
   */
  boolean okToAbandon() {
    if (!dirty) {
      return true;
    }
    message1.setButtonSet(Message.YES_NO_CANCEL);
    message1.setTitle("Text Edit");
    message1.setMessage("Save changes?");
    message1.show();
    switch (message1.getResult()) {
       case Message.YES:
         // yes, please save changes
         return saveFile();
       case Message.NO:
         // no, abandon edits
         // i.e. return true without saving
         return true;
       case Message.CANCEL:
       default:
         // cancel
         return false;
    }
  }

  /**
   * Update the caption of the application to show the filename and its dirty state.
   */
  void updateCaption() {
    String caption;

    if (currFileName == null) {
       // synthesize the "Untitled" name if no name yet.
       caption = "Untitled";
    }
    else {
      caption = currFileName;
    }

    // add a "*" in the caption if the file is dirty.
    if (dirty) {
      caption = "* " + caption;
    }
    caption = "TextEdit - " + caption;
    this.setTitle(caption);
  }

  /**
   * Override DecoratedFrame's system close handler
   */
  protected void processWindowEvent(WindowEvent e) {
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      if (okToAbandon()) {
        System.exit(0);
      }
    }
  }

  //File | Exit action performed
  public void fileExit_actionPerformed(ActionEvent e) {
    if (okToAbandon()) {
      System.exit(0);
    }
  }

  //Help | About action performed
  public void helpAbout_actionPerformed(ActionEvent e) {
    helpAbout();
  }

  void menuItem5_actionPerformed(java.awt.event.ActionEvent e) {
    // Handle the "Edit Font" menu item

    // Pick up the existing font from the TextArea
    // and put it into the FontChooser before showing
    // the FontChooser, so that we are editing the
    // existing / previous font.
    fontChooser1.setValue(textArea1.getFont());

    // Show the FontChooser.
    // Since the FontChooser is modal by default,
    // the program will not return from the call
    // to show until the user dismisses the FontChooser
    // using OK or Cancel.
    fontChooser1.show();

    // Now that the user has dismissed the FontChooser,
    // obtain the new Font from the FontChooser's
    // value property.  First test the result property to see if the
    // user pressed OK.
    if (fontChooser1.getResult() == FontChooser.OK) {

      // Set the font of textArea1 to the font
      // value that can be obtained from the
      // value property of fontChooser1.  This
      // font value is what the user entered
      // before pressing the OK button
      textArea1.setFont(fontChooser1.getValue());
    }
  }

  void menuItem6_actionPerformed(ActionEvent e) {
    // Handle the "Foreground Color" menu item

    // Pick up the existing text (foreground) color from the TextArea
    // and put it into the ColorChooser before showing
    // the ColorChooser, so that we are editing the
    // existing text color.
    colorChooser1.setValue(textArea1.getForeground());

    // Before showing it, set the title of the dialog for its
    // particular use in this event (for setting the text color)
    colorChooser1.setTitle("Set Text Color");
    
    // Show the ColorChooser.
    // Since the ColorChooser is modal by default,
    // the program will not return from the call
    // to show until the user dismisses the ColorChooser
    // using OK or Cancel.
    colorChooser1.show();
    

    // Now that the user has dismissed the ColorChooser,
    // obtain the new color from the ColorChooser's
    // value property. First test the result property to see if the
    // user pressed OK.
    if (colorChooser1.getResult() == ColorChooser.OK) {
      // set the foreground of textArea1 to the color
      // value that can be obtained from the
      // value property of colorChooser1.  This
      // color value is what the user set
      // before pressing the OK button
      textArea1.setForeground(colorChooser1.getValue());
    }
  }

  void menuItem7_actionPerformed(ActionEvent e) {
    colorChooser1.setValue(textArea1.getBackground());
    colorChooser1.setTitle("Set Background Color");
    colorChooser1.show();
    if (colorChooser1.getResult() == ColorChooser.OK) {
      textArea1.setBackground(colorChooser1.getValue());
    }
  }

  void menuItem1_actionPerformed(ActionEvent e) {
    // Handle the File|New menu item.
    if (okToAbandon()) {
      // clear the text of the TextArea
      textArea1.setText("");
      // clear the current filename and set the file as clean:
      currFileName = null;
      dirty = false;
      updateCaption();
    }
  }

  void menuItem2_actionPerformed(ActionEvent e) {
    // Handle the File|Open menu item.
    fileOpen();
  }

  void menuItem3_actionPerformed(ActionEvent e) {
    saveFile();
  }

  void menuItem4_actionPerformed(ActionEvent e) {
    saveAsFile();
  }

  void buttonBar_actionPerformed(ActionEvent e) {
    String actionCommand = e.getActionCommand();
    if (actionCommand.equals("Open")) {
      fileOpen();
    }
    else if (actionCommand.equals("Save")) {
      saveFile();
    }
    else if (actionCommand.equals("About")) {
      helpAbout();
    }
  }

  void textArea1_textValueChanged(TextEvent e) {
    if (!dirty) {
      dirty = true;
      updateCaption();
    }
  }
}

class TextEditFrame_menuFileExit_ActionAdapter implements ActionListener {
  TextEditFrame adaptee;

  TextEditFrame_menuFileExit_ActionAdapter(TextEditFrame adaptee) {
    this.adaptee = adaptee;
  }

  public void actionPerformed(ActionEvent e) {
    adaptee.fileExit_actionPerformed(e);
  }
}

class TextEditFrame_menuHelpAbout_ActionAdapter implements ActionListener {
  TextEditFrame adaptee;

  TextEditFrame_menuHelpAbout_ActionAdapter(TextEditFrame adaptee) {
    this.adaptee = adaptee;
  }

  public void actionPerformed(ActionEvent e) {
    adaptee.helpAbout_actionPerformed(e);
  }
}

class TextEditFrame_AboutBox extends Dialog implements ActionListener {
  Panel panel1 = new Panel();
  BevelPanel bevelPanel1 = new BevelPanel();
  TextEditFrame_InsetsPanel insetsPanel1 = new TextEditFrame_InsetsPanel();
  TextEditFrame_InsetsPanel insetsPanel2 = new TextEditFrame_InsetsPanel();
  TextEditFrame_InsetsPanel insetsPanel3 = new TextEditFrame_InsetsPanel();
  Button button1 = new Button();
  ImageControl imageControl1 = new ImageControl();
  Label label1 = new Label();
  Label label2 = new Label();
  Label label3 = new Label();
  Label label4 = new Label();
  BorderLayout borderLayout1 = new BorderLayout();
  BorderLayout borderLayout2 = new BorderLayout();
  FlowLayout flowLayout1 = new FlowLayout();
  GridLayout gridLayout1 = new GridLayout();
  String product = "Your Product Name";
  String version = "";
  String copyright = "Copyright (c) 1997";
  String comments = "Your description";

  public TextEditFrame_AboutBox(Frame parent) {
    super(parent);
    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
    pack();
  }

  void jbInit() throws Exception{
    this.setTitle("About");
    setResizable(false);
    panel1.setLayout(borderLayout1);
    bevelPanel1.setLayout(borderLayout2);
    insetsPanel2.setLayout(flowLayout1);
    insetsPanel2.setInsets(new Insets(10, 10, 10, 10));
    gridLayout1.setRows(4);
    gridLayout1.setColumns(1);
    label1.setText(product);
    label2.setText(version);
    label3.setText(copyright);
    label4.setText(comments);
    insetsPanel3.setLayout(gridLayout1);
    insetsPanel3.setInsets(new Insets(10, 60, 10, 10));
    button1.setLabel("OK");
    button1.addActionListener(this);
    imageControl1.setImageName("");
    insetsPanel2.add(imageControl1, null);
    bevelPanel1.add(insetsPanel2, BorderLayout.WEST);
    this.add(panel1, null);
    insetsPanel3.add(label1, null);
    insetsPanel3.add(label2, null);
    insetsPanel3.add(label3, null);
    insetsPanel3.add(label4, null);
    bevelPanel1.add(insetsPanel3, BorderLayout.CENTER);
    insetsPanel1.add(button1, null);
    panel1.add(insetsPanel1, BorderLayout.SOUTH);
    panel1.add(bevelPanel1, BorderLayout.NORTH);
    pack();
  }

  public void actionPerformed(ActionEvent e) {
    if (e.getSource() == button1) {
    setVisible(false);
    dispose();
    }
  }
}

class TextEditFrame_InsetsPanel extends Panel {
  protected Insets insets;

  public Insets getInsets() {
    return insets == null ? super.getInsets() : insets;
  }

  public void setInsets(Insets insets) {
    this.insets = insets;
  }
}

class TextEditFrame_menuItem5_actionAdapter implements java.awt.event.ActionListener {
  TextEditFrame adaptee;

  TextEditFrame_menuItem5_actionAdapter(TextEditFrame adaptee) {
    this.adaptee = adaptee;
  }

  public void actionPerformed(ActionEvent e) {
    adaptee.menuItem5_actionPerformed(e);
  }
}

class TextEditFrame_menuItem6_actionAdapter implements java.awt.event.ActionListener {
  TextEditFrame adaptee;

  TextEditFrame_menuItem6_actionAdapter(TextEditFrame adaptee) {
    this.adaptee = adaptee;
  }

  public void actionPerformed(ActionEvent e) {
    adaptee.menuItem6_actionPerformed(e);
  }
}

class TextEditFrame_menuItem7_actionAdapter implements java.awt.event.ActionListener {
  TextEditFrame adaptee;

  TextEditFrame_menuItem7_actionAdapter(TextEditFrame adaptee) {
    this.adaptee = adaptee;
  }

  public void actionPerformed(ActionEvent e) {
    adaptee.menuItem7_actionPerformed(e);
  }
}

class TextEditFrame_menuItem1_actionAdapter implements java.awt.event.ActionListener {
  TextEditFrame adaptee;

  TextEditFrame_menuItem1_actionAdapter(TextEditFrame adaptee) {
    this.adaptee = adaptee;
  }

  public void actionPerformed(ActionEvent e) {
    adaptee.menuItem1_actionPerformed(e);
  }
}

class TextEditFrame_menuItem2_actionAdapter implements java.awt.event.ActionListener {
  TextEditFrame adaptee;

  TextEditFrame_menuItem2_actionAdapter(TextEditFrame adaptee) {
    this.adaptee = adaptee;
  }

  public void actionPerformed(ActionEvent e) {
    adaptee.menuItem2_actionPerformed(e);
  }
}

class TextEditFrame_menuItem3_actionAdapter implements java.awt.event.ActionListener {
  TextEditFrame adaptee;

  TextEditFrame_menuItem3_actionAdapter(TextEditFrame adaptee) {
    this.adaptee = adaptee;
  }

  public void actionPerformed(ActionEvent e) {
    adaptee.menuItem3_actionPerformed(e);
  }
}

class TextEditFrame_menuItem4_actionAdapter implements java.awt.event.ActionListener {
  TextEditFrame adaptee;

  TextEditFrame_menuItem4_actionAdapter(TextEditFrame adaptee) {
    this.adaptee = adaptee;
  }

  public void actionPerformed(ActionEvent e) {
    adaptee.menuItem4_actionPerformed(e);
  }
}

class TextEditFrame_buttonBar_actionAdapter implements java.awt.event.ActionListener {
  TextEditFrame adaptee;

  TextEditFrame_buttonBar_actionAdapter(TextEditFrame adaptee) {
    this.adaptee = adaptee;
  }

  public void actionPerformed(ActionEvent e) {
    adaptee.buttonBar_actionPerformed(e);
  }
}

class TextEditFrame_textArea1_textAdapter implements java.awt.event.TextListener {
  TextEditFrame adaptee;

  TextEditFrame_textArea1_textAdapter(TextEditFrame adaptee) {
    this.adaptee = adaptee;
  }

  public void textValueChanged(TextEvent e) {
    adaptee.textArea1_textValueChanged(e);
  }
}

